/*____________________________________________________________________________
	Copyright (C) 2000 Networks Associates Technology, Inc.
	All rights reserved.

	$Id: pgpMilliseconds.c,v 1.5.2.1 2001/05/16 21:17:45 gglawits Exp $
____________________________________________________________________________*/
#include "pgpPFLConfig.h"
#include "pgpDebug.h"

#ifdef __MVS__
#include <time.h>
#else
#if PGP_MACINTOSH
#include <OpenTransport.h>
#elif PGP_WIN32
#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#elif PGP_UNIX
#include <sys/param.h>
	#if PGP_UNIX_DARWIN
	#include <sys/times.h>
	#endif
#endif
#endif

#include "pgpMilliseconds.h"

	PGPUInt32
PGPGetMilliseconds()
{
	/* Returns milliseconds since system startup */
#if PGP_MACINTOSH
	OTTimeStamp timeStamp;
	
	OTGetTimeStamp( &timeStamp );
	return OTTimeStampInMilliseconds( &timeStamp );
#elif PGP_WIN32
	return GetTickCount();
#elif PGP_UNIX
	/*
	 * times() returns clock ticks since system boot.
	 * HZ is clock ticks per second.
	 */
#if PGP_UNIX_DARWIN
	return times( NULL ) / CLK_TCK * 1000;
#else
	return times( NULL ) / HZ * 1000;
#endif
#else
	pgpAssert( 0 );	/* not implemented */
#endif
}


/*__Editor_settings____

	Local Variables:
	tab-width: 4
	End:
	vi: ts=4 sw=4
	vim: si
_____________________*/
